/** @file   eng2dPrivateConstants.h
 * @brief   Defines the private constants used by this library.
 * @version $Revision: 1.3 $
 * @date    $Date: 2006/02/24 12:21:33 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_PRIVATECONSTANTS_H
#define H_ENG2D_PRIVATECONSTANTS_H

namespace eng2d {

/** Maximum line length in characters. */
const int KMaxLineLength = 4096;
/** Newline character */
const char KCharNewLine = '\n';
/** Character that starts the comment line */
#define KStrCommentLine "#"

/** Maximum number of nodes the path found by A* algorithm can have by
 * default.
 */
const int KAStarMaximumPathNodes = 250;



// Comment this to turn logging off.
#define DISABLE_LOGGING

#ifdef DISABLE_LOGGING

  #define ENG2D_LOGGING( mess )

#else

  #define ENG2D_LOGGING( mess ) \
          { \
            std::ofstream logfout("eng2d.log", std::ios::app ); \
            if ( !logfout == false ) { \
              logfout << (const char*) mess << std::endl; \
            } \
            logfout.close(); \
          }
#endif


    
};

#endif
